//
//  TipCalculator.as
//
// This is an example of event handling using the Forms feature
// and new V2 components of Flash MX Professional 2004
//

import mx.controls.TextInput;
import mx.controls.RadioButton;
import mx.controls.RadioButtonGroup;

class TipCalculator extends mx.screens.Form
{
    // Declarations for the various components
	var subtotal:TextInput;
	var gratuity:TextInput;
	var radioGroup:RadioButtonGroup;
	var percentRadio15:RadioButton;
	var percentRadio18:RadioButton;
	var percentRadio20:RadioButton;

    // Initialization routine for the form.
    // Add event handlers for the subtotal text input and
    // the percentage radio buttons.
    public function onLoad():Void
	{
		subtotal.addEventListener("change", this);
		percentRadio15.addEventListener("click", this);
		percentRadio18.addEventListener("click", this);
		percentRadio20.addEventListener("click", this);
	}
	
    // Utility routine for converting a numeric amount
    // to a dollars-and-cents string
	private function formatCurrency(value:Number):String
	{
        var cents:Number = Math.round(value*100);
		var result:String = "$" + Math.floor(cents/100) + ".";
		cents %= 100;
		if (cents < 10) {
		    result += "0";
        }
        result += String(cents);
        return result;
    }

    // Recalculate the gratuity text field based on the
    // subtotal input by the user, and the current
    // tip percentage
    private function calculate():Void
	{
        var percent:Number = Number(radioGroup.selection.data);
    	var tip:Number = Number(subtotal.text) * percent;
        if (isNaN(tip)) {						 
            gratuity.text = "";
        } else {
            gratuity.text = formatCurrency(tip);
        }
	}

    // Event handler for "change"
    // If user changes subtotal, recalculate gratuity
    public function change(event:Object):Void
	{
        if (event.target == subtotal) {
            calculate();
        }
    }

    // Event handler for "click"
    // If user clicks a different percentage, recalculate gratuity
    public function click(event:Object):Void
	{
        switch (event.target) {
          case percentRadio15:
          case percentRadio18:
          case percentRadio20:
            calculate();
            break;
        }
    }
}

